package ru.yandex.travel.hotels.common.partners.vipservice.model

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit
import java.math.BigDecimal
import java.time.LocalDate

data class AgencyPriceItem(
    val currency: ProtoCurrencyUnit,
    val price: BigDecimal,
    val priceBreakdown: Map<LocalDate, BigDecimal>,
    val isVatIncluded: Boolean,
    val vatAmount: BigDecimal,
    val markupAmount: BigDecimal,
    val markupBreakdown: Map<LocalDate, BigDecimal>,
    val markupData: MarkupData,
    val commissionAmount: BigDecimal,
    val commissionBreakdown: Map<LocalDate, BigDecimal>,
    val commissionData: CommissionData,
)
