package ru.yandex.travel.hotels.common.partners.vipservice.model

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.JsonDeserializer
import ru.yandex.travel.commons.proto.ProtoCurrencyUnit

class CurrencyDeserializer : JsonDeserializer<ProtoCurrencyUnit>() {
    override fun deserialize(parser: JsonParser, context: DeserializationContext): ProtoCurrencyUnit? {
        val currencyCode = parser.text
        if (currencyCode.isNotBlank()) {
            return ProtoCurrencyUnit.fromCurrencyCode(currencyCode)
        }
        return null
    }
}
