package ru.yandex.travel.hotels.common.partners.vipservice.model

import com.fasterxml.jackson.annotation.JsonSubTypes
import com.fasterxml.jackson.annotation.JsonTypeInfo
import ru.yandex.travel.commons.proto.ProtoCurrencyUnit
import java.math.BigDecimal

data class ExtraService(
    val name: String,
    val code: String,
    val included: Boolean,

    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "code", include = JsonTypeInfo.As.EXTERNAL_PROPERTY)
    @JsonSubTypes(
        JsonSubTypes.Type(value = ExtraServiceValue.ExtraServiceTime::class, name = "early_check_in"),
        JsonSubTypes.Type(value = ExtraServiceValue.ExtraServiceTime::class, name = "late_check_out"),
    )
    val value: ExtraServiceValue?,

    val price: BigDecimal,
    val currency: ProtoCurrencyUnit,
)
