package ru.yandex.travel.hotels.common.partners.vipservice.model

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit
import java.math.BigDecimal
import java.time.LocalDate


data class Offer(
    val hash: String,
    val currency: ProtoCurrencyUnit,
    val price: BigDecimal,
    val priceBreakdown: Map<LocalDate, BigDecimal>,
    val isVatIncluded: Boolean,
    val vatAmount: BigDecimal,
    val cityId: Int,
    val hotelId: Int,
    val providerId: Int,
    val roomName: String,
    val cancelConditions: CancelConditions,
    val availableRooms: Int?,
    val extras: List<ExtraService>,
    val meals: List<Meal>,
    val description: String,
    val bookingInfo: Set<BookingInfoFlag>?,
    val taxes: List<Tax>?, // ???
    val infoForGuest: String?,
)
