RECURSE(src/test)
JAVA_LIBRARY()

JDK_VERSION(11)
WITH_KOTLIN()
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

OWNER(g:travel-hotels)
JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)

PEERDIR(
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin
    contrib/java/com/googlecode/libphonenumber/libphonenumber
    contrib/java/io/springfox/springfox-swagger2
    contrib/java/org/asynchttpclient/async-http-client
    travel/library/java/commons
    travel/library/java/yt-lucene-index
    travel/hotels/proto2
    travel/hotels/lib/java/commons
    travel/hotels/lib/java/partner_parsers/proto
    travel/hotels/lib/java/models
    travel/hotels/proto/bronevik
    travel/hotels/proto/expedia
    travel/hotels/proto/dolphin
    travel/orders/proto
    contrib/java/org/apache/logging/log4j/log4j-core
    contrib/java/com/sun/xml/ws/jaxws-ri
    contrib/java/javax/xml/bind/jaxb-api
)

SET(
    WSIMPORT_ARGS
    -keep -s ${BINDIR}/generated
    -b src/main/resources/bronevikCustomJaxWSSettings.xml
    -b src/main/resources/bronevikCustomJaxbBindings.xjb
    -p ru.yandex.travel.hotels.common.partners.bronevik
    -Xnocompile
    -extension -B-XautoNameResolution
    -B-Xannotate
    -B-Xsetters -B-Xsetters-mode=direct
    -B-XReplacePrimitives
    -B-XJsr303Annotations
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/bronevik.wsdl
    IN src/main/resources/bronevik.wsdl src/main/resources/bronevikCustomJaxWSSettings.xml src/main/resources/bronevikCustomJaxbBindings.xjb
    OUT_DIR generated
    CLASSPATH travel/library/java/maven-plugins/wsimport
)

NO_LINT()
# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/com/googlecode/libphonenumber/libphonenumber/8.10.2
    contrib/java/com/sun/xml/ws/jaxws-ri/2.3.2
)

END()
