import sys
from typing import List
import time

import progressbar

import logging

LOG = logging.getLogger(__name__)


def make_widgets(title: str, total: int) -> List:
    return [
        title + ' ',
        progressbar.AnimatedMarker(),
        progressbar.Bar(marker='█', fill='░', left=' ', right=' '),
        progressbar.Counter(),
        '/',
        str(total),
        ' (',
        progressbar.Percentage(),
        ') ',
        progressbar.AdaptiveETA(),
    ]


def create_progress_bar(name: str, total: int) -> progressbar.ProgressBar:
    fd = sys.stderr
    if fd.isatty():
        return progressbar.ProgressBar(fd=fd, max_value=total, widgets=make_widgets(name, total))
    else:
        return progressbar.NullBar()


def log_progress_reporter(iterator, name='', total=None):
    if name:
        pfx = f'{name}: '
    else:
        pfx = ''

    def print_report(i):
        if total:
            LOG.info(f'{pfx}{i}/{total} done')
        else:
            LOG.info(f'{pfx}{i} done')

    last_report = 0
    cnt = 0
    for item in iterator:
        now = time.time()
        if now - last_report > 5:
            print_report(cnt)
            last_report = time.time()
        yield item
        cnt += 1
    print_report(cnt)


def auto_progress_reporter(iterator, name='', total=None):
    fd = sys.stderr
    if fd.isatty():
        return progressbar.progressbar(iterator=iterator, fd=fd, max_value=total, widgets=make_widgets(name, total))
    else:
        return log_progress_reporter(iterator, name=name, total=total)
