from functools import wraps


def auto_str(cls=None, *, ignore=None):
    if cls is None:
        return lambda c: auto_str(c, ignore=ignore)

    if ignore is None:
        ignore = []

    @wraps(cls)
    def __str__(self):
        cls_name = type(self).__name__
        fields = ', '.join(f'{variable}={value}' for variable, value in vars(self).items() if variable not in ignore)
        return f'{cls_name}({fields})'

    cls.__str__ = __str__
    return cls
