from enum import Enum


class ExtendedEnum(Enum):
    @classmethod
    def values(cls):
        return list(map(lambda x: x.value, cls))

    @classmethod
    def enums(cls):
        return list(cls)


class UseValueAsToStringMixin:
    def __str__(self):
        return self.value


class UseValueAsReprMixin:
    def __repr__(self):
        return self.value
