from typing import Dict
import requests


class TankerClient:
    def __init__(self, tanker_url: str):
        self.tanker_url = tanker_url

    def load_keyset(self, project_id: str, keyset_id: str, lang: str = 'ru', branch_id: str = 'master') -> Dict[str, str]:
        url = f'{self.tanker_url}/keysets/json/'
        query_params = {
            'language': lang,
            'project-id': project_id,
            'branch-id': branch_id,
            'keyset-id': keyset_id,
            'status': 'unapproved',
            'no-comments': 'true',
            'flat-keyset': 'true',
        }
        rsp = requests.get(url, params=query_params)
        rsp.raise_for_status()
        return rsp.json()[lang]
