import logging
import time
from threading import Thread

from ticket_parser2.api.v1 import TvmClient, TvmClientStatus, TvmApiClientSettings


class Tvm:
    def __init__(self, service_id, client_id, client_secret):
        self.logger = logging.Logger('TVM')

        self.ticket = None
        self.client = None
        if not client_secret:
            raise Exception('Missing required argument "client_secret"')
        destinations = {'api': service_id}
        settings = TvmApiClientSettings(
            self_client_id=client_id,
            enable_service_ticket_checking=True,
            enable_user_ticket_checking=False,
            self_secret=client_secret,
            dsts=destinations,
        )
        self.client = TvmClient(settings)
        if self.client.status != TvmClientStatus.Ok:
            raise Exception("tvm client has bad status: " + TvmClient.status_to_string(self.client.status))
        self.update_ticket()

        self.update_thread = Thread(target=self.loop, name='TVM-background-updater')
        self.update_thread.daemon = True
        self.update_thread.start()

    def update_ticket(self):
        try:
            self.ticket = self.client.get_service_ticket_for('api')
            self.logger.info("Got new TVM ticket")
        except:
            self.logger.exception('Failed to get ticket')

    def loop(self):
        while True:
            time.sleep(600)
            self.update_ticket()

    def get_ticket(self):
        return self.ticket
