import time
from collections import deque


class Throttler:
    def __init__(self, max_rps, window_size=1):
        if window_size * max_rps < 1.0:
            raise Exception(f'Too small window for such rps. Should be not less than {1.0 / max_rps}')
        self.max_rps = max_rps
        self.window_size = window_size
        self.request_timestamps = deque()

    def delay_before_next_call(self):
        while True:
            now = time.time()
            window_start = now - self.window_size
            while len(self.request_timestamps) > 0 and self.request_timestamps[0] < window_start:
                self.request_timestamps.popleft()
            requests_done = len(self.request_timestamps)
            requests_allowed = self.max_rps * self.window_size
            if requests_done < requests_allowed:
                self.request_timestamps.append(now)
                break
            time.sleep(self.request_timestamps[0] - window_start + 0.01)
