from typing import Union

from yt.wrapper import YPath, YtClient, create, remove


class TmpPath:
    def __init__(self, path: Union[str, YPath], yt_client: YtClient, *, keep: bool = False, keep_on_error: bool = True):
        self.path = YPath(path)
        self.yt_client = yt_client
        self.keep = keep
        self.keep_on_error = keep_on_error

    def __enter__(self):
        if not self.yt_client.exists(self.path):
            create('map_node', self.path, recursive=True, ignore_existing=False, client=self.yt_client)
        return self.path

    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.keep:
            return
        if exc_type is None or not self.keep_on_error:
            remove(self.path, recursive=True, client=self.yt_client)
