#include <travel/hotels/offercache/service/service.h>
#include <travel/hotels/offercache/proto/config.pb.h>

#include <travel/hotels/lib/cpp/yt/tools.h>
#include <travel/hotels/lib/cpp/protobuf/config.h>
#include <travel/hotels/lib/cpp/protobuf/tools.h>
#include <travel/hotels/lib/cpp/util/profiletimer.h>
#include <travel/hotels/lib/cpp/util/signals.h>

#include <library/cpp/getopt/opt.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/sighandler/async_signals_handler.h>
#include <library/cpp/svnversion/svnversion.h>


int main(int argc, const char* argv[]) {
    NTravel::TProfileTimer::Init();
    SetupSignalHandlers();
    InitGlobalLog2Console(TLOG_INFO);
    TString configDir, env, ytTokenPath, ypTokenPath, redirAddInfoKeyPath;
    bool dbg;
    {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption('h');
        opts.AddLongOption('c', "config-dir", "Path to config dir")
            .Required()
            .StoreResult(&configDir);
        opts.AddLongOption('e', "env", "Environment")
            .StoreResult(&env)
            .DefaultValue("dev");
        opts.AddLongOption('t', "yt-token-path", "Yt TokenPath")
            .StoreResult(&ytTokenPath);
        opts.AddLongOption('p', "yp-token-path", "Yp TokenPath")
            .StoreResult(&ypTokenPath);
        opts.AddLongOption('l', "redir-addinfo-key-path", "Redir AddInfo key path")
            .StoreResult(&redirAddInfoKeyPath);
        opts.AddLongOption('d', "debug", "Enable debug log")
            .SetFlag(&dbg).NoArgument();
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    }
    TFsPath configPath(configDir);
    //-------- Read service config
    auto pbCfg = NTravel::ReadAppConfigWithSubstitutions<NTravelProto::NOfferCache::TConfig>("offercache", configPath, env, ytTokenPath, ypTokenPath);
    if (redirAddInfoKeyPath) {
        INFO_LOG << "Redir AddInfo Key Path override to " << redirAddInfoKeyPath << Endl;
        pbCfg.MutableOther()->SetRedirAddInfoKeyPath(redirAddInfoKeyPath);
    }

    DoInitGlobalLog(CreateLogBackend(pbCfg.GetOther().GetMainLogFile(), dbg ? TLOG_DEBUG : TLOG_INFO, true));

    INFO_LOG << "Starting OfferCache revision " << GetProgramSvnRevision() << ", built on " << GetProgramBuildDate() << Endl;
    NTravel::NYtRpc::Init();

    {
        NTravel::NOfferCache::TService service(pbCfg, env);
        for (int signal: {SIGINT, SIGTERM}) {
            SetAsyncSignalFunction(signal, [&service](int) {
                service.Stop();
            });
        }

        service.Start();
        service.Wait();
    }
    INFO_LOG << "Shutting down YT RPC..." << Endl;
    NTravel::NYtRpc::Shutdown();
    INFO_LOG << "Shutdown finished" << Endl;
    return 0;
}
