#pragma once

#include <travel/hotels/proto/offercache_api/aux.pb.h>
#include <travel/hotels/offercache/proto/config.pb.h>
#include <travel/hotels/lib/cpp/http/http_service.h>

#include <util/generic/vector.h>

namespace NTravel {
namespace NOfferCache {

class TCache;

class TCacheHeatmap {
public:
    TCacheHeatmap(const TCache& cache, const NTravelProto::NOfferCache::TConfig::TCacheHeatmap& pbCfg);
    ~TCacheHeatmap();

    void BuildCacheHeatmap(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb) const;
private:
    const TCache& Cache_;
    TVector<NTravelProto::NOfferCache::TConfig::TCacheHeatmap::TBucket> Buckets_;

    TString BuildHTMLCacheHeatmap(const NTravelProto::NOfferCache::NApi::THeatmapReq& req) const;
    void BuildProtoCacheHeatmap(const NTravelProto::NOfferCache::NApi::THeatmapReq& req, NTravelProto::NOfferCache::NApi::THeatmapResp* resp) const;
};

}// namespace NOfferCache
}// namespace NTravel
