#pragma once

#include "data.h"

#include <travel/hotels/proto2/hotels.pb.h>
#include <travel/hotels/offercache/proto/grpc_reqans_logrecord.pb.h>

#include <travel/hotels/lib/cpp/grpc/grpc_async_server.h>

#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NTravel {
namespace NOfferCache {

class TService;

using TReqAnsRecord = NTravelProto::NOfferCache::NGrpcReqAnsLog::TGrpcReqAnsLogRecord;

class TGrpcJob : public TThrRefBase {
public:
    TGrpcJob(TService& svc, ui64 id, const TOfferCacheGrpcServer::TResponseCb<NTravelProto::TSearchOffersRpcRsp>& responseCb, TInstant started);
    ~TGrpcJob();
    void Start(const NTravelProto::TSearchOffersRpcReq& origReq, const NGrpc::TServerReqMetadata& srvMeta);
private:
    TService& Service;
    const TString LogPrefix;
    const TOfferCacheGrpcServer::TResponseCb<NTravelProto::TSearchOffersRpcRsp> ResponseCb;
    const TInstant Started;

    NGrpc::TServerReqMetadata ReqMeta;
    NTravelProto::TSearchOffersRpcReq Req;
    NTravelProto::TSearchOffersRpcRsp Resp;

    void ValidateGrpcSubrequest(const NTravelProto::TSearchOffersRpcReq& req, const NTravelProto::TSearchOffersReq& subReq) const;

    void OnSearcherRequestFinished(TDuration dur, const TVector<size_t> origPos,
                                   const NTravelProto::TSearchOffersRpcReq& searcherRpcReq, const NTravelProto::TSearchOffersRpcRsp& searcherRpcResp);

    void WriteGrpcReqAnsLog() const;
};

using TGrpcJobRef = TIntrusivePtr<TGrpcJob>;

}// namespace NOfferCache
}// namespace NTravel
