#pragma once

#include "data.h"
#include "cache.h"

#include <travel/hotels/offercache/proto/interconnect_bus.pb.h>
#include <travel/hotels/offercache/proto/reqans_logrecord.pb.h>
#include <travel/hotels/proto/data_config/offercache_client.pb.h>
#include <travel/hotels/proto/offercache_grpc/offercache_service.grpc.pb.h>
#include <travel/hotels/proto2/label.pb.h>

#include <travel/hotels/lib/cpp/util/profiletimer.h>
#include <travel/hotels/lib/cpp/grpc/grpc_async_server.h>

#include <google/protobuf/repeated_field.h>

#include <util/generic/ptr.h>

namespace NTravel::NOfferCache {
    class TService;

    class TGrpcReadJob : public TThrRefBase {
     public:
        typedef NGrpc::TAsyncServer<NTravelProto::NOfferCacheGrpc::OfferCacheServiceV1::AsyncService> TGrpcOfferCacheServer;
        typedef TGrpcOfferCacheServer::TResponseCb<NTravelProto::NOfferCache::NApi::TReadResp> TOnResponse;

        TGrpcReadJob(TService& svc, const TOnResponse& onResp, TInstant started, ui64 id);
        ~TGrpcReadJob() override;
        void Start(const NTravelProto::NOfferCache::NApi::TReadReq& req, const NGrpc::TServerReqMetadata& srvMeta);
     private:
        TService& Service;
        const TOnResponse& ResponseCb;
        const TInstant Started;
        const TString LogPrefix;

        TProfileTimer LifespanTimer;
        TProfileTimer StagesTimer;

        TAtomicSharedPtr<TReadJobStats> StatsPtr;
    };
}
