#pragma once

#include <travel/hotels/offercache/proto/config.pb.h>

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/permalink_mappers/mappers/permalink_to_original_ids_mapper.h>

#include <util/generic/ptr.h>
#include <util/system/mutex.h>

#include <memory>

namespace NTravel {
namespace NOfferCache {

class THotelsWhitelist: public NPermalinkMappers::TPermalinkToOriginalIdsMapper {
    using TConfig = NTravelProto::NOfferCache::TConfig::THotelsWhitelist;
    using TPartnerHotels = THashMap<EPartnerId, TVector<TString/*OriginalId*/>>;
public:
    struct TPartnerCounters: public NMonitor::TCounterSource, public TThrRefBase {
        NMonitor::TDerivCounter NPermalinkOnlyMatched;
        NMonitor::TDerivCounter NOriginalIdOnlyMatched;
        NMonitor::TDerivCounter NFullMatch;
        NMonitor::TDerivCounter NNothingMatched;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    THotelsWhitelist(const TConfig& config);

    void RegisterCounters(NMonitor::TCounterSource& source);

    bool IsInWhitelist(TPermalink permalink, const THotelId& hotelId) const;

    bool IsWhitelistedPartner(EPartnerId partnerId);

    bool IsAllowedByWhitelist(TPermalink permalink, const THotelId& hotelId) const;

    void FilterPartnerHotels(TPermalink permalink, THashSet<THotelId>* hotelIds) const; // filter out only non-whitelisted partner hotels for whitelisted partners
private:
    mutable NMonitor::TCounterHypercube<TPartnerCounters> PartnerCounters_;

    THashSet<EPartnerId> HotelsWhitelistPartners_;

    TRWMutex Lock_;
    TPartnerHotels PartnerHotels_;

    bool IsWhitelistedHotel(const TValue* whitelistedHotel, const THotelId& hotelId) const;
};

}// namespace NOfferCache
}// namespace NTravel
