#pragma once

#include "data.h"
#include "cache.h"

#include <travel/hotels/offercache/proto/interconnect_bus.pb.h>
#include <travel/hotels/offercache/proto/reqans_logrecord.pb.h>
#include <travel/hotels/proto/data_config/offercache_client.pb.h>
#include <travel/hotels/proto2/label.pb.h>

#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/util/profiletimer.h>

#include <google/protobuf/repeated_field.h>

#include <util/generic/ptr.h>

namespace NTravel {
namespace NOfferCache {

class TService;

class THttpReadJob : public TThrRefBase {
public:
    THttpReadJob(TService& svc, NHttp::TOnResponse onResp, TInstant started, ui64 id);
    ~THttpReadJob();
    void Start(const NHttp::TRequest& httpReq);
private:
    TService& Service;
    const NHttp::TOnResponse ResponseCb;
    const TInstant Started;
    const TString LogPrefix;

    TProfileTimer LifespanTimer;
    TProfileTimer StagesTimer;

    TAtomicSharedPtr<TReadJobStats> StatsPtr;
};

using THttpReadJobRef = TIntrusivePtr<THttpReadJob>;

}// namespace NOfferCache
}// namespace NTravel
