#include "offer_utils.h"
#include "service.h"

namespace NTravel::NOfferCache {
    bool TOfferUtils::OfferLessByOperatorAndOfferId(const TService& service, const TOffer& lhs, const TOffer& rhs) {
        size_t order1 = service.GetOperatorOrder(lhs.OperatorId);
        size_t order2 = service.GetOperatorOrder(rhs.OperatorId);
        if (order1 != order2) {
            return order1 < order2;
        }
        return ToString(lhs.OfferId) < ToString(rhs.OfferId);
    }
}
