#pragma once

#include "data.h"
#include "outdated_record_builder.h"

#include <travel/hotels/lib/cpp/yt/queue_writer.h>
#include <travel/hotels/lib/cpp/yt/deduplicaton_service.h>
#include <travel/hotels/lib/cpp/yp_auto_resolver/yp_auto_resolver.h>
#include <travel/hotels/proto2/bus_messages.pb.h>

#include <util/generic/vector.h>
#include <util/generic/queue.h>

namespace NTravel::NOfferCache {
    class TOutdatedOffersTransmitter {
    public:
        TOutdatedOffersTransmitter(TYtQueueWriter& outdatedOfferWriter, TOutdatedRecordBuilder& outdatedRecordBuilder, const NTravelProto::NOfferCache::TConfig::TOutdatedOffersTransmitter& config);
        void ProcessOutdatedOfferBusMessage(TInstant timestamp, const TString& messageId, const ru::yandex::travel::hotels::TSearcherMessage& message);
        void ProcessOfferBusMessage(TInstant timestamp, const TString& messageId, const ru::yandex::travel::hotels::TSearcherMessage& message, const TVector<TCacheRecordRef>& records);
        void Start();
        void Stop();
        bool IsReady() const;
        void RegisterCounters(NMonitor::TCounterSource& source) const;
    private:
        struct TCounters: public NMonitor::TCounterSource {
            NMonitor::TCounter          DesiredDelaySec;
            NMonitor::TCounter          RealDelaySec;
            NMonitor::TCounter          QueueHeadDelaySec;
            NMonitor::TCounter          NQueueRecords;
            NMonitor::TCounter          NQueueBytes;
            NMonitor::TDerivCounter     NNewMessagesDropped;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        struct TQueueRecord {
            const TInstant WriteTime;
            const TInstant Timestamp;
            const TString MessageId;
            const ru::yandex::travel::hotels::TSearcherMessage Message;

            size_t CalcTotalByteSize() const;
        };

        const NTravelProto::NOfferCache::TConfig::TOutdatedOffersTransmitter& Config_;
        TDeduplicationService DeduplicationService_;
        TYtQueueWriter& OutdatedOfferWriter_;
        TOutdatedRecordBuilder& OutdatedRecordBuilder_;
        TYpAutoResolver YpAutoResolver_;
        std::atomic<int> WriteDelaySec_;
        std::atomic<ui64> QueueSizeBytes_;

        TMutex QueueMutex_;
        TQueue<TQueueRecord> Queue_;

        TAtomicFlag IsReady_;
        TAtomicFlag IsStarted_;
        TAtomicFlag IsStopping_;
        TAutoEvent StopEvent_;
        TAutoPtr<IThreadFactory::IThread> WriterThread_;

        TCounters Counters_;

        TString TransformMessageId(const TString& messageId) const;
        void ConsumeRecords();
        void OnQueueUpdate(const TQueueRecord& rec, int sign);
    };
}
