#pragma once

#include "data.h"

#include <travel/hotels/offercache/proto/config.pb.h>

#include <util/generic/vector.h>

namespace NTravel::NOfferCache {
    class TOutdatedRecordBuilder {
    public:
        TOutdatedRecordBuilder(TService& service, const NTravelProto::NOfferCache::TConfig::TOutdatedPrices& config);
        bool AreOutdatedPricesEnabled() const;
        TDuration GetOutdatedPriceLifetime() const;
        TMaybe<TCacheRecordRef> ConvertToOutdated(const TCacheRecordRef& record);
    private:
        TVector<TOffer> BuildOffers(const TVector<TOffer>& offers);
        TOffer ConvertOffer(const TOffer& offer);
        TService& Service_;
        const TDuration OutdatedPriceLifetime_;
        const bool EnableOutdatedPrices_;
    };
}
