#pragma once

#include "data.h"

#include <travel/hotels/proto/data_config/rate_plans/travelline_rate_plan_info.pb.h>
#include <travel/hotels/proto/data_config/rate_plans/dolphin_list_record.pb.h>
#include <travel/hotels/proto/data_config/rate_plans/bnovo_rate_plan_info.pb.h>

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>

#include <tuple>

namespace NTravel::NOfferCache {
    class TPartnerDataOfferFilter {
    public:
        TPartnerDataOfferFilter(const NTravelProto::NAppConfig::TYtTableCacheConfig& YtConfigTravellineRatePlans,
                                const NTravelProto::NAppConfig::TYtTableCacheConfig& YtConfigDolphinTour,
                                const NTravelProto::NAppConfig::TYtTableCacheConfig& YtConfigDolphinPansion,
                                const NTravelProto::NAppConfig::TYtTableCacheConfig& YtConfigDolphinRoom,
                                const NTravelProto::NAppConfig::TYtTableCacheConfig& YtConfigDolphinRoomCat,
                                const NTravelProto::NAppConfig::TYtTableCacheConfig& YtConfigBNovoRatePlans,
                                bool unkownTravellineItemIsBanned,
                                bool unkownDolphinItemIsBanned,
                                bool unkownBNovoItemIsBanned,
                                TServiceCounters& serviceCounters);

        void RegisterCounters(NMonitor::TCounterSource& source);
        void Start();
        void Stop();
        void SetIsReadyFlags(std::function<void(const TString& name, bool isReady)> setFlag) const;
        NTravelProto::NOfferCache::NApi::ESkipReason GetSkipReasonOrNone(const TString& logPrefix, const TOffer& offer) const;

    private:
        TYtPersistentConfig<TTravelLineRatePlanKey, NTravelProto::NConfig::TTravellineRatePlanInfo> TravellineRatePlansConfig_;
        TYtPersistentConfig<ui64, NTravelProto::NConfig::TDolphinListRecord> DolphinTourConfig_;
        TYtPersistentConfig<ui64, NTravelProto::NConfig::TDolphinListRecord> DolphinPansionConfig_;
        TYtPersistentConfig<ui64, NTravelProto::NConfig::TDolphinListRecord> DolphinRoomConfig_;
        TYtPersistentConfig<ui64, NTravelProto::NConfig::TDolphinListRecord> DolphinRoomCatConfig_;
        TYtPersistentConfig<TBNovoRatePlanKey, NTravelProto::NConfig::TBNovoRatePlanInfo> BNovoRatePlansConfig_;
        bool UnkownTravellineItemIsBanned_;
        bool UnkownDolphinItemIsBanned_;
        bool UnkownBNovoItemIsBanned_;
        TServiceCounters& ServiceCounters_;
    };
}
