#pragma once

#include "data.h"
#include "cache.h"

#include <travel/hotels/offercache/proto/interconnect_bus.pb.h>
#include <travel/hotels/offercache/proto/reqans_logrecord.pb.h>
#include <travel/hotels/proto/data_config/offercache_client.pb.h>
#include <travel/hotels/proto2/label.pb.h>

#include <travel/hotels/lib/cpp/util/profiletimer.h>
#include <travel/hotels/lib/cpp/util/exp.h>

#include <google/protobuf/repeated_field.h>

#include <util/generic/ptr.h>

namespace NTravel {
namespace NOfferCache {

class TService;

class TReadRequestProcessor: public TThrRefBase {
public:
    typedef std::function<size_t(const NTravelProto::NOfferCache::NApi::TReadResp&)> TOnResponse;

    TSourceCountersRef SourceCounters;

    TReadRequestProcessor(const TAtomicSharedPtr<TReadJobStats>& statsPtr, TService& svc, TInstant started, const TString& logPrefix, const TMaybe<TString>& rawHttpRequest = {});
    ~TReadRequestProcessor() override;

    void Parse(const NTravelProto::NOfferCache::NApi::TReadReq& req);
    void Process(const TReadRequestProcessor::TOnResponse& onResp);
private:
    friend class TOfferBlender;  //shame on me or not?

    TService& Service;
    const TInstant Started;
    const NOrdinalDate::TOrdinalDate Today;
    const TString LogPrefix;
    const TMaybe<TString> RawHttpRequest;

    NTravelProto::TRequestAttribution Attribution;

    TProfileTimer LifespanTimer;
    TProfileTimer StagesTimer;
    THashSet<EPartnerId> EnabledPartners;
    THashSet<EOperatorId> EnabledOperators;

    bool BoYMode;
    // Если true, то для поиска основных отелей в кэше используются EnabledPartnersBoY и EnabledOperatorsBoY
    // При этом "похожие" ищутся среди всех партнёров
    THashSet<EPartnerId> EnabledPartnersBoY;
    THashSet<EOperatorId> EnabledOperatorsBoY;

    THashSet<EOperatorId> ActualOperators; // Операторы, упомянутые в ответе
    THashSet<EOCPansion> ActualPansions; // Типы питания, упомянутые в ответе
    TPriceValRange TotalPriceValRange;

    ERequestType RequestType;
    NOrdinalDate::TOrdinalDate MinAllowedDate;
    size_t TotalPartnerCount;
    THashSet<EPartnerId> CompletePartners;
    THashSet<EPartnerId> IncompletePartners;
    TPermalink MainPermalink; // Только для статистики в SearchProps и в Solomon
    bool MainPermalinkIsBlacklisted;
    bool MainPermalinkIsGreylistedNoOffers;
    THashMap<TPermalink, TPermalink> ClusterPermalinks;
    THashMap<TPermalink, TComplexHotelId>  ComplexHotelIds;
    THashMap<TPermalink, size_t> PermalinkOrder; // Порядок пермалинков в запросе
    THashSet<TPermalink> SimilarPermalinks; // Похожие отели: По этим отелям не производим обределение подключа
    THashSet<TPermalink> SingleOrgPermalinks; // 1орг отели: которые имеют шанс стать 1оргом
    THashSet<TPermalink> FullyGreylistedPermalinks;
    TSearchSubKey SubKey; // Вначале из запроса, позже исправляется по результатам поиска в кэше
    TSearchSubKey UserSubKey;
    TSearchSubKey DefaultSubKey;
    TSearchSubKeyRange SubKeyRange;
    bool IsInitialRequest; // Первичный ли это запрос
    NTravelProto::NOfferCache::NApi::TReadReq           Req;
    NTravelProto::NOfferCache::NApi::TReadResp          Resp;
    THashMap<TPermalink, THashMap<THotelId, TVector<TCacheRecordRef>>>  Records;
    TCacheSearchStat CacheStat;
    TAtomicSharedPtr<TReadJobStats> StatsPtr;
    TReadJobStats& Stats;
    THashSet<TPermalink> FullyFoundPermalinks;// Permalink-и, у которых были в кэше найдены все партнёрские HotelId-ы
    THashSet<TPermalink> PartiallyFoundPermalinks;// Permalink-и, у которых были в кэше найдена часть партнёрских HotelId-ов
    THashSet<TPermalink> IncompletePermalinks; // Пермалинки, по которым сёрчер делает запрос
    THashMap<TString, THotelId> SearcherRequests; // RequestId -> HotelId
    TExp Exp;
    TUserInfo UserInfo;

    void Reply(const TReadRequestProcessor::TOnResponse& onResp);
    void WriteToOfferReqBus() const;
    void WriteReqAnsLog() const;
    void ReportBaseFiltersStats() const;

    bool HotelIdFromApiProto(const NTravelProto::NOfferCache::NApi::TComplexHotelId::TPartnerCodeAndHotelId& pb, THotelId* hotelId) const;
    void HotelIdToProto(const THotelId& hotelId, NTravelProto::THotelId* pb) const;

    NOrdinalDate::TOrdinalDate CropDate(NOrdinalDate::TOrdinalDate dt) const; // Сделать дату не меньше MinAllowedDate
    TPermalink GetClusterPermalink(TPermalink permalink) const;
    void ParseAttribution();
    void ParseIntList(const TString& name, const TString& src, ::google::protobuf::RepeatedField< ::google::protobuf::int64 >* dst) const;
    void ParseSubKey();
    void ParseSubKeyRangeAndDefaultSubKey();
    void ConvertSHotelIds();
    void AdjustSubKeyRangeForMirPromo();
    double GetMirPromoAvailableTop10Ratio() const;
    bool IsMirPromoAvailableTop10() const;
    void ParseHotelIds(size_t* subHotelCount);
    void ParseEnabledOperatorsAndPartners();
    void FilterOnlyBoYOperatorsAndPartners();
    void InitProgress();
    void DetermineRequestType();
    void InitUserInfo();

    EPermalinkType GetPermalinkType(TPermalink permalink) const;
    void CheckPermalinkSubHotels(TPermalink permalink, bool* isBoY, bool* isBoYDirect) const;

    bool IsMirPromoAvailable(TPermalink permalink) const;

    void SearchInCache();
    void FillCacheStatus(const THotelId& hotelId, const TVector<TCacheRecordRef>& records,
                         NTravelProto::NOfferCache::NApi::THotelExtra::TSubHotelInfo* subHotelInfo) const;
    void DoSearchInCache(const THashMap<TPreKey, THashSet<TPermalink>>& preKeysForSearch,
                         const TSearchSubKey& defaultSubKey,
                         TSearchSubKey* subKey);

    void DoSearcherRequest();
    void OnSearcherRequestFinished(TDuration dur, const NTravelProto::TSearchOffersRpcReq& rpcReq, const NTravelProto::TSearchOffersRpcRsp& rpcResp);
    void PrepareSearcherRequest(NTravelProto::TSearchOffersRpcReq* rpcReq);
    TPollingId CalculatePollingId() const;

    void PrepareLabel(NTravelProto::TLabel* label) const;
    TString PrepareRedirAddInfo() const;

    void InitHotelsInResp();
    TBlendingStageTimes PutRecordsToResp();
    void PutSearchPropsToResp();
    void PutOperatorInfosToResp();
    void PutPartnerInfosToResp();
    void PutPansionInfosToResp();
    void PutPansionInfoToResp(EOCPansion pansion);
    void PutTotalPriceRangeToResp();

    NTravelProto::NOfferCache::NApi::THotelExtra::TSubHotelInfo* GetSubHotelInfo(const THotelId& hotelId, NTravelProto::NOfferCache::NApi::THotelExtra& extra) const;

    void WriteInteractiveSearchEvent() const;
    void AdjustSubKeyForUser();
};

}// namespace NOfferCache
}// namespace NTravel
