#pragma once

#include <travel/hotels/offercache/service/data.h>

#include <contrib/libs/re2/re2/re2.h>

namespace NTravel::NOfferCache {
    class TOfferToRoomKeyMapper {
    public:
        explicit TOfferToRoomKeyMapper(TServiceCounters& counters);

        TString GetCatRoomMappingKey(const TOffer& offer, const TString& decompressedTitle) const;
        static TString PrepareKey(const TString& s);

    private:
        static const re2::RE2 TrailingBracesPattern;
        static const re2::RE2 AfterHyphenPattern;

        TString CutTrailingBraces(const TString& s) const;
        TString CutAfterHyphen(const TString& s) const;

        TServiceCounters& Counters;
    };
}
