#pragma once

#include "room_data.h"

#include <travel/hotels/offercache/proto/config.pb.h>
#include <travel/hotels/offercache/proto/room_data_rec.pb.h>

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/yt/table_cache.h>
#include <travel/hotels/lib/cpp/util/object_deduplicator.h>

namespace NTravel::NOfferCache {
    class TRoomService {
    public:
        struct TGetHotelPermaroomsRequest {
            THotelId HotelId;
            TVector<TPermaroomMappingKey> MappingKeys;
        };

        struct TRoomServiceResult {
            THashMap<TPermaroomMappingKey, TMaybe<TPermaroomIdStr>> Mapping;
            THashMap<TPermaroomIdStr, TPermaroom> Permarooms;
        };

        explicit TRoomService(const NTravelProto::NOfferCache::TConfig::TRoomService& roomServiceConfig, std::function<EPartnerId(EOperatorId)> getPartnerByOperator);

        void RegisterCounters(NMonitor::TCounterSource& source);
        void Start();
        void Stop();
        bool IsReady() const;

        TRoomServiceResult GetPermarooms(const TCatRoomDataSourceIdStr& dsId,
                                         const TVector<TGetHotelPermaroomsRequest>& perHotelRequests);

    private:
        struct TDataItem {
            TUnique<TPermaroomVersion> PermaroomVersion;
            TUnique<TPermaroomInner> PermaroomInner;
        };

        using TInnerDataType = THashMap<TObjectDeduplicator::TUnique<TPermaroomMappingSubKey>, TDataItem>;
        using TDataType = THashMap<TObjectDeduplicator::TUnique<THotelId>, TInnerDataType>;

        struct TCatRoomData {
            TCatRoomData(const TString& name, const NTravelProto::NAppConfig::TYtTableCacheConfig& config)
                : Name(name)
                , OldData(MakeAtomicShared<TDataType>())
                , Data(MakeAtomicShared<TDataType>())
                , NewData(MakeAtomicShared<TDataType>())
                , DataTable(name, config)
            {
            }

            TString Name;
            TAtomicFlag Ready;
            TMutex Mutex;
            TAtomicSharedPtr<TDataType> OldData;
            TAtomicSharedPtr<TDataType> Data;
            TAtomicSharedPtr<TDataType> NewData;
            TYtTableCache<NTravelProto::NOfferCache::TRoomDataRec> DataTable;
        };

        struct TCounters: public NMonitor::TCounterSource {
            NMonitor::TCounter IsReady;
            NMonitor::TCounter NOldDataBytes;
            NMonitor::TCounter NOldDataRecords;
            NMonitor::TCounter NDataBytes;
            NMonitor::TCounter NDataRecords;
            NMonitor::TCounter NNewDataBytes;
            NMonitor::TCounter NNewDataRecords;
            NMonitor::TDerivCounter UrlParseFailure;
            NMonitor::TDerivCounter UnknownDSId;
            NMonitor::TDerivCounter TooBigPhoto;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        NTravelProto::NOfferCache::TConfig::TRoomService Config_;
        TAtomicFlag RoomDataReady_;
        THashMap<TString, std::unique_ptr<TCatRoomData>> DataSources_;
        TObjectDeduplicator Objects_;
        TCounters Counters_;
        std::function<EPartnerId(EOperatorId)> GetPartnerByOperator_;
        TAtomicFlag Started_;

        void InitDataTables();
    };
}
