#pragma once

#include <travel/hotels/offercache/proto/config.pb.h>
#include <travel/hotels/offercache/proto/interconnect_bus.pb.h>
#include <travel/hotels/offercache/service/data.h>

#include <library/cpp/containers/concurrent_hash/concurrent_hash.h>
#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/system/rwlock.h>


namespace NTravel::NOfferCache {

class TUserEventsStorage {
public:
    TUserEventsStorage(const NTravelProto::NOfferCache::TConfig::TUserEventsStorage& cfg);
    ~TUserEventsStorage();

    bool IsEnabled() const;

    void RegisterCounters(NMonitor::TCounterSource& counters);

    bool OnInteractiveSearchEvent(const NTravelProto::NOfferCache::TInteractiveSearchEvent& pbEvent, TInstant eventTs);

    TMaybe<TSearchSubKey> FindSearchSubKey(const TUserIdentifier& userId) const;
private:
    static constexpr size_t BucketCount_ = 256;

    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TCounter      NInteractiveSearchEvents; // Событий интерактивного поиска
        NMonitor::TCounter      NBytes;                   // Количество потраченной памяти

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    struct TInteractiveSearchEvent {
        TSearchSubKey SubKey;
        TInstant ExpTime;

        size_t GetAllocSize() const;
    };

    const bool Enabled_;
    const TDuration CleanupPeriod_;
    const TDuration InteractiveSearchEventTTL_;

    mutable TCounters Counters_;

    using TInteractiveSearchEventMap = TConcurrentHashMap<TUserIdentifier, TInteractiveSearchEvent, BucketCount_, TRWMutex>;
    TInteractiveSearchEventMap InteractiveSearchEvents_;
    TConcurrentHashMap<TInstant, THashSet<TInteractiveSearchEventMap::TBucket*>, BucketCount_, TRWMutex> CleanupSchedule_;

    void ExecuteCleanup(TInstant cleanupTime);
    TDuration CleanupBucket(TInteractiveSearchEventMap::TBucket* bucketPtr, TInstant expTime);

    void OnRecordRemoved(const TInteractiveSearchEvent& ise) const;
    void OnRecordAdded(const TInteractiveSearchEvent& ise) const;
};

} // namespace NTravel::NOfferCache
