#pragma once

#include "data.h"
#include <travel/hotels/offercache/proto/config.pb.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/maybe.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>

namespace NTravel::NOfferCache {
    using TWiteLabelProtoConfig = NTravelProto::NOfferCache::TConfig::TPromoService::TWhiteLabel;
    using EWhiteLabelPointsType = NTravelProto::NWhiteLabel::EWhiteLabelPointsType;

    class TWLBasePointsConfig {
    public:
        virtual ~TWLBasePointsConfig() = default;
        virtual ui32 CalculatePointsOffer(ui32 totalPrice) const = 0;
    };
    typedef TAtomicSharedPtr<TWLBasePointsConfig> TWLBasePointsConfigRef;

    class TWLPointsPerAmountConfig: public TWLBasePointsConfig {
    public:
        TWLPointsPerAmountConfig(ui32 points, ui32 amount);
        ui32 CalculatePointsOffer(ui32 totalPrice) const override;

    private:
        ui32 Points_;
        ui32 Amount_;
    };

    class TWhiteLabelPromoService {
    public:
        TWhiteLabelPromoService(const TWiteLabelProtoConfig& config);
        ~TWhiteLabelPromoService();

        struct TForOfferInternalReq {
            TInstant Now;
            TPriceWithCurrency LatestPrice;
            NTravelProto::NPromoService::TUserInfo UserInfo;
            NTravelProto::NPromoService::TExperimentInfo ExpInfo;
            NTravelProto::NPromoService::TWhiteLabelInfo WhiteLabelInfo;
        };

        void FillPointsLinguistics(ui32 pointsAmount, EWhiteLabelPointsType pointsType, NTravelProto::NPromoService::TWhiteLabelPointsLinguistics* linguistics) const;
        void FillStatus(const TForOfferInternalReq& req, NTravelProto::NPromoService::TWhiteLabelStatus* res) const;

    private:
        struct TLinguistic {
            TString SingleNominative;
            TString SingleGenitive;
            TString PluralGenitive;
        };

        struct TPointsOffer {
            TString EventId;
            ui32 PointsAmount;
            EWhiteLabelPointsType PointsType;
        };

        struct TWLEventConfig {
            TString EventId;
            TWLBasePointsConfigRef PointsConfig;
            EWhiteLabelPointsType PointsType;
            TMaybe<TInstant> OrderTimeStartUtc;
            TMaybe<TInstant> OrderTimeEndUtc;
        };

        struct TWlPromoConfig {
            bool Enabled;
            TWLBasePointsConfigRef DefaultPointsConfig;
            EWhiteLabelPointsType DefaultPointsType;
            TVector<TWLEventConfig> Events;
        };

        const THashMap<EWhiteLabelPointsType, TLinguistic> PointsTypeLinguistic_;
        const TWlPromoConfig S7Promo_;

    private:
        THashMap<EWhiteLabelPointsType, TLinguistic> MakeConfig(const TWiteLabelProtoConfig::TPointsTypeLinguistic& pbCfg) const;
        TWlPromoConfig MakeConfig(const TWiteLabelProtoConfig::TWLPromoConfig& pbCfg) const;
        TWLBasePointsConfigRef ParsePointsConfig(const TWiteLabelProtoConfig::TWLPointsConfig& ppCfg) const;
        TString GetNameForNumeralNominative(ui32 pointsAmount, EWhiteLabelPointsType pointsType) const;

        void FillWLStatus(const TForOfferInternalReq& req, NTravelProto::NPromoService::TWhiteLabelStatus* res, const TWlPromoConfig& promo) const;
    };
} // namespace NTravel::NOfferCache
