LIBRARY()

OWNER(g:travel-hotels)

SRCS(
    cache.cpp
    cache_heatmap.cpp
    counters.cpp
    data.cpp
    grpc_job.cpp
    grpc_read_job.cpp
    http_read_job.cpp
    hotels_whitelist.cpp
    offer_blender.cpp
    offer_utils.cpp
    outdated_offers_transmitter.cpp
    outdated_record_builder.cpp
    partner_data_offer_filter.cpp
    promo_service.cpp
    read_request_processor.cpp
    req_cache.cpp
    rooms/offer_to_room_key_mapper.cpp
    rooms/room_service.cpp
    rooms/room_data.cpp
    searcher_client.cpp
    service.cpp
    user_events_storage.cpp
    white_label_promo_service.cpp
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(counters.h)

PEERDIR(
    travel/hotels/proto/extranet_api
    travel/hotels/proto/offercache_api
    travel/hotels/proto/offercache_grpc
    travel/hotels/offercache/proto
    travel/hotels/proto/app_config
    travel/hotels/proto/data_config
    travel/hotels/proto/promo_service
    travel/hotels/proto/redir_add_info
    travel/hotels/proto2
    travel/hotels/lib/cpp/ages
    travel/hotels/lib/cpp/data
    travel/hotels/lib/cpp/encryption
    travel/hotels/lib/cpp/grpc
    travel/hotels/lib/cpp/http
    travel/hotels/lib/cpp/label
    travel/hotels/lib/cpp/logging
    travel/hotels/lib/cpp/permalink_mappers/mappers
    travel/hotels/lib/cpp/protobuf
    travel/hotels/lib/cpp/util
    travel/hotels/lib/cpp/mon
    travel/hotels/lib/cpp/offer_cache_invalidation
    travel/hotels/lib/cpp/ordinal_date
    travel/hotels/lib/cpp/memusage
    travel/hotels/lib/cpp/scheduler
    travel/hotels/lib/cpp/yp_auto_resolver
    travel/hotels/lib/cpp/yt
    travel/proto/order_type
    travel/proto/user_order_counters
    library/cpp/yaml/as
    library/cpp/containers/concurrent_hash
    library/cpp/digest/md5
    library/cpp/logger/global
    library/cpp/html/entity
    library/cpp/http/misc
    library/cpp/http/server
    library/cpp/mime/types
    library/cpp/protobuf/json
    library/cpp/resource
    library/cpp/uri
    library/cpp/xml/document
    mapreduce/yt/interface
    yt/yt/client
    library/cpp/cgiparam
    library/cpp/string_utils/quote
    library/cpp/codecs
    library/cpp/digest/crc32c
    contrib/libs/re2
    contrib/libs/grpc/grpc++_reflection
    library/cpp/deprecated/atomic
)

RESOURCE(
    travel/hotels/devops/resources/translations.yaml resources/translations.yaml
)

END()
