package handler

import (
	"a.yandex-team.ru/travel/hotels/pacific_api/internal/healthswitch"
	"a.yandex-team.ru/travel/library/go/httputil"
	"github.com/go-chi/chi/v5"
	"net/http"
	"net/url"
	"strconv"
)

type HTTPHealthSwitchHandler struct {
	sw *healthswitch.Switch
}

func NewHTTPHealthSwitchHandler(sw *healthswitch.Switch) *HTTPHealthSwitchHandler {
	return &HTTPHealthSwitchHandler{sw: sw}
}

func (h *HTTPHealthSwitchHandler) SetHealth(w http.ResponseWriter, r *http.Request) {
	params, err := url.ParseQuery(r.URL.RawQuery)
	if err != nil {
		httputil.HandleError(err, http.StatusBadRequest, w)
		return
	}

	health := params.Get("health")
	s, err := strconv.ParseBool(health)
	if err != nil {
		httputil.HandleError(err, http.StatusBadRequest, w)
		return
	}

	h.sw.SetHealth(s)
	w.WriteHeader(http.StatusOK)
	w.Header().Set("Content-Type", "application/json")
	_, _ = w.Write([]byte("Ok"))
}

func (h *HTTPHealthSwitchHandler) GetRouteBuilder() func(r chi.Router) {
	return func(r chi.Router) {
		r.Get("/health", h.SetHealth)
	}
}
