package healthswitch

import "sync"

type Switch struct {
	sync.Mutex

	healthy bool
}

func NewSwitch() *Switch {
	return &Switch{healthy: true}
}

func (s *Switch) SetHealth(h bool) {
	s.Lock()
	defer s.Unlock()
	s.healthy = h
}

func (s *Switch) GetHealth() bool {
	s.Lock()
	defer s.Unlock()
	return s.healthy
}
