from dateutil import parser


class Offer(object):
    def __init__(self, id, num, room_id, room_type_id, price, num_adults, num_children, pansion, mobile=False):
        self.mobile = mobile
        self.id = id
        self.num = num
        self.room_id = room_id
        self.room_type_id = room_type_id
        self.price = price
        self.num_adults = num_adults
        self.num_children = num_children
        self.pansion = pansion


class Occupancy(object):
    def __init__(self, num_adults, child_ages):
        self.num_adults = num_adults
        self.child_ages = child_ages


class Request(object):
    def __init__(self, checkin, checkout, occupancy, hotel_ids, mobile=False):
        self.mobile = mobile
        self.checkin = checkin
        self.checkout = checkout
        self.occupancy = occupancy
        self.hotel_ids = hotel_ids

    def get_checkin_date(self):
        return parser.parse(self.checkin)

    def get_check_out_date(self):
        return parser.parse(self.checkout)

    @property
    def nights(self):
        return (self.get_check_out_date() - self.get_checkin_date()).days


class HotelInfo(object):
    def __init__(self, hotel_id, city_id):
        self.hotel_id = hotel_id
        self.city_id = city_id


class Result(object):
    def __init__(self, hotel_id, offers, hotel_info=None):
        self.hotel_id = hotel_id
        self.offers = offers
        self.hotel_info = hotel_info


class Response(object):
    def __init__(self, id, results):
        self.id = id
        self.results = results
        self.extra = {}
