#include <travel/hotels/pricechecker/service/service.h>
#include <travel/hotels/pricechecker/proto/config.pb.h>

#include <travel/hotels/lib/cpp/yt/tools.h>
#include <travel/hotels/lib/cpp/protobuf/config.h>
#include <travel/hotels/lib/cpp/protobuf/tools.h>
#include <travel/hotels/lib/cpp/util/signals.h>

#include <library/cpp/getopt/opt.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/sighandler/async_signals_handler.h>
#include <library/cpp/svnversion/svnversion.h>

int main(int argc, const char* argv[]) {
    SetupSignalHandlers();
    InitGlobalLog2Console(TLOG_INFO);

    TString configDir, env, ytTokenPath;
    bool dbg;
    {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption('h');
        opts.AddLongOption('c', "config-dir", "Path to config dir").Required().StoreResult(&configDir);
        opts.AddLongOption('e', "env", "Environment").StoreResult(&env).DefaultValue("dev");
        opts.AddLongOption('t', "yt-token-path", "Path to YT token").StoreResult(&ytTokenPath);
        opts.AddLongOption('d', "debug", "Enable debug log").SetFlag(&dbg).NoArgument();
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    }
    TFsPath configPath(configDir);
    auto pbCfg = NTravel::ReadAppConfigWithSubstitutions<NTravelProto::NPriceChecker::TConfig>("pricechecker", configPath, env, ytTokenPath, "");

    DoInitGlobalLog(CreateLogBackend(pbCfg.GetOther().GetMainLogFile(), dbg ? TLOG_DEBUG : TLOG_INFO, true));

    INFO_LOG << "Starting PriceChecker revision " << GetProgramSvnRevision() << ", built on " << GetProgramBuildDate() << Endl;

    NTravel::NYtRpc::Init();
    {
        NTravel::NPriceChecker::TService service(pbCfg);
        for (int signal: {SIGINT, SIGTERM}) {
            SetAsyncSignalFunction(signal, [&service](int) {
                service.Stop();
            });
        }
        service.Run();
    }
    NTravel::NYtRpc::Shutdown();

    INFO_LOG << "Shutdown finished" << Endl;
    return 0;
}
