#pragma once

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/ordinal_date/ordinal_date.h>
#include <travel/hotels/pricechecker/proto/filtering_state_message.pb.h>
#include <travel/hotels/proto2/hotels.pb.h>

#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/queue.h>
#include <util/generic/string.h>
#include <util/datetime/base.h>
#include <util/system/mutex.h>

namespace NTravel::NPriceChecker {
    class TService;
    class TOfferFilter {
    public:
        TOfferFilter(TService& service, double baseRate);
        void RegisterCounters(NMonitor::TCounterSource& source, const TString& name);
        bool ShouldFollowOffer(TInstant timestamp, const NTravelProto::TSearchOffersReq& request, const NTravelProto::TOffer& offer);
        NTravelProto::NPriceChecker::TFilteringState ToProto() const;
        void FromProto(const NTravelProto::NPriceChecker::TFilteringState& filteringState);

    private:
        struct TBucket {
            size_t CurrentCount;
            size_t NextCount;
        };

        struct TCounters: public NMonitor::TCounterSource {
            NMonitor::TCounter NSeenOffers;
            NMonitor::TCounter NSampledOffers;

            NMonitor::TDerivCounter NSeenOffersRate;
            NMonitor::TDerivCounter NSampledOffersRate;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        using BucketKey = std::tuple<TString, int, int>;

        constexpr static TDuration WindowSize = TDuration::Hours(3);

        const double BaseRate_;
        const TService& Service_;

        TMutex Lock_;
        THashMap<BucketKey, TBucket> Buckets_;
        TBucket TotalBucket_;
        TInstant LastBucketRotationTimestamp_;

        BucketKey GetBucketKey(TInstant timestamp, const NTravelProto::TSearchOffersReq& request, const NTravelProto::TOffer& offer) const;

        NMonitor::TCounterHypercube<TCounters> Counters_;
    };

}
