#pragma once

#include "offer_filter.h"
#include "offer_tracker_counters.h"
#include "tracking_strategy.h"

#include <travel/hotels/lib/cpp/grpc/grpc_async_client.h>
#include <travel/hotels/lib/cpp/yt/queue_reader.h>
#include <travel/hotels/lib/cpp/yt/queue_writer.h>
#include <travel/hotels/pricechecker/proto/pricechecker_logrecord.pb.h>
#include <travel/hotels/pricechecker/proto/tracking_state_message.pb.h>
#include <travel/hotels/proto/app_config/grpc.pb.h>
#include <travel/hotels/proto2/bus_messages.pb.h>
#include <travel/hotels/proto/offercache_grpc/offercache_service.grpc.pb.h>

namespace NTravel::NPriceChecker {
    class TService;

    class TOfferTracker {
    public:
        static const TString PriceCheckerOfferCacheClientId;

        TOfferTracker(TService& service,
                      const TString& name,
                      const NTravelProto::NAppConfig::TConfigGrpcClient& offerCacheClientConfig,
                      const NTravelProto::NPriceChecker::TConfig::TTrackingStrategy& trackingStrategyConfig,
                      const NTravelProto::NAppConfig::TConfigYtQueueReader& stateBusReaderConfig,
                      const NTravelProto::NAppConfig::TConfigYtQueueWriter& stateBusWriterConfig,
                      const NTravelProto::NPriceChecker::TConfig::TOfferTracker& offerTrackerConfig);
        void RegisterCounters(NMonitor::TCounterSource& source);
        void Subscribe(std::function<void(const TOfferTrackingState&)> handler);
        bool ProcessSearcherMessage(const TYtQueueMessage& busMessage, const ru::yandex::travel::hotels::TSearcherMessage& parsedMessage);
        void SetInitializationFinishHandler(std::function<void(void)> handler);
        void Start();
        void Stop();

    private:
        const TDuration TombstoneDuration_;
        const TDuration SearcherResponseTimeout_;
        const TString Name_;

        TOfferFilter OfferFilter_;
        std::function<void(const TOfferTrackingState&)> FinishedCheckHandler_;
        NGrpc::TAsyncClient<NTravelProto::NOfferCacheGrpc::OfferCacheServiceV1> OfferCacheClient_;
        TOfferTrackerCounters Counters_;
        TTrackingStrategy TrackingStrategy_;
        TYtQueueReader StateBusReader_;
        TYtQueueWriter StateBusWriter_;
        std::function<void(void)> InitializationFinishHandler_;
        NTravelProto::NPriceChecker::TConfig::TOfferTracker OfferTrackerConfig_;

        TMutex MaxLoadedFilteringStateTimestampLock_;
        TInstant MaxLoadedFilteringStateTimestamp_;

        TMutex TrackingStatesLock_;
        THashMap<TString, std::shared_ptr<TOfferTrackingState>> TrackingStates_;
        TInstant MaxLoadedTimestamp_;

        bool ProcessTrackingStateMessage(const TYtQueueMessage& busMessage);
        bool ProcessFilteringStateMessage(const TYtQueueMessage& busMessage);
        void StartNewTracking(TInstant timestamp,
                              const NTravelProto::TSearchOffersReq& requestPb,
                              const NTravelProto::TOffer& offerPb);
        void HandleCheckResult(TInstant timestamp, const NTravelProto::TSearchOffersReq& request, const NTravelProto::TSearchOffersRsp& response);
        void HandleRpcError(const std::shared_ptr<TOfferTrackingState>& trackingState, size_t checkIndex, const TString& error);
        void ScheduleNextCheckOrStop(const std::shared_ptr<TOfferTrackingState>& trackingState, TInstant now);
        void StopTracking(TOfferTrackingState* trackingState);
        void SaveState(TOfferTrackingState* trackingState);
        void ReportStateSize();

        static TString GetRequestIdByKey(const TString& key, int index);
        static TMaybe<std::pair<TString, size_t>> GetKeyByRequestId(const TString& requestId);
    };

}
