#pragma once

#include <travel/hotels/lib/cpp/mon/counter.h>

namespace NTravel::NPriceChecker {
    struct TOfferTrackerCounters: public NMonitor::TCounterSource {
        NMonitor::TCounter NActiveTrackings;
        NMonitor::TCounter NWaitingChecks;
        NMonitor::TCounter NInFlyChecks;
        NMonitor::TCounter TrackerByteSize;
        NMonitor::TCounter TrackerSpaceUsed;

        NMonitor::TDerivCounter NMemoryMeasuringTimeSec;
        NMonitor::TDerivCounter NOutdatedChecks;
        NMonitor::TDerivCounter NCorruptedTrackings;
        NMonitor::TDerivCounter NTrackingsWithEmptyChecks;
        NMonitor::TDerivCounter NResponseToNotActiveTracking;
        NMonitor::TDerivCounter NResponseToFinishedChecking;
        NMonitor::TDerivCounter NDuplicateRequestId;
        NMonitor::TDerivCounter NNotFoundTracking;
        NMonitor::TDerivCounter NCreatedTrackings;
        NMonitor::TDerivCounter NScheduledChecks;
        NMonitor::TDerivCounter NCompletedTrackings;
        NMonitor::TDerivCounter NBusResponseErrors;
        NMonitor::TDerivCounter NRpcErrors;
        NMonitor::TDerivCounter NSearcherTimeouts;
        NMonitor::TDerivCounter NSentRpcRequests;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

}
