#pragma once

#include <travel/hotels/pricechecker/proto/price_filter_data.pb.h>

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/grpc/grpc_async_client.h>
#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/permalink_mappers/mappers/permalink_to_cluster_mapper.h>
#include <travel/hotels/lib/cpp/permalink_mappers/mappers/permalink_to_original_ids_mapper.h>
#include <travel/hotels/lib/cpp/yt/table_cache.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>
#include <travel/hotels/proto/offercache_grpc/offercache_service.grpc.pb.h>
#include <travel/hotels/proto/data_config/partner.pb.h>

namespace NTravel::NPriceChecker {
    class TPriceFilterChecker {
    public:
        static const TString PriceFilterCheckerOfferCacheClientId;

        TPriceFilterChecker(const NTravelProto::NAppConfig::TConfigGrpcClient& offerCacheClientConfig,
                            const NTravelProto::NAppConfig::TYtTableCacheConfig& priceFilterTableConfig,
                            const NTravelProto::NAppConfig::TYtTableCacheConfig& permalinkToClusterMapper,
                            const NTravelProto::NAppConfig::TYtTableCacheConfig& permalinkToOriginalIdsMapper,
                            const NTravelProto::NAppConfig::TYtTableCacheConfig& ytConfigPartners,
                            double rps);
        void RegisterCounters(NMonitor::TCounterSource& source, const TString& name);
        void Start();
        void Stop();
        bool ProcessSearcherMessage(const TYtQueueMessage& busMessage, const ru::yandex::travel::hotels::TSearcherMessage& parsedMessage);

    private:
        struct TSpecificCounters: public NMonitor::TCounterSource {
            NMonitor::TDerivCounter NNoOffers;

            NMonitor::TDerivCounter NBordersBothOk;
            NMonitor::TDerivCounter NBordersWrongMin;
            NMonitor::TDerivCounter NBordersWrongMax;
            NMonitor::TDerivCounter NBordersBothWrong;

            NMonitor::TDerivCounter NOverlapRealRangeInside;
            NMonitor::TDerivCounter NOverlapHasIntersection;
            NMonitor::TDerivCounter NOverlapNoIntersection;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        struct TCommonCounters: public NMonitor::TCounterSource {
            NMonitor::TDerivCounter NSentRpcRequests;
            NMonitor::TDerivCounter NRpcErrors;
            NMonitor::TDerivCounter NBusResponseErrors;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;
        };

        struct RunningCheck {
            RunningCheck() {
            }

            RunningCheck(bool withDates, size_t priceFilterInd, size_t totalRequests)
                : WithDates(withDates)
                , PriceFilterInd(priceFilterInd)
                , TotalRequests(totalRequests)
            {
            }

            bool WithDates;
            size_t PriceFilterInd;
            size_t TotalRequests;
            TVector<NTravelProto::TSearchOffersRsp> Responses;
        };

        void CheckPriceFilters();
        void CheckPriceFilter(int epoch, int priceFilterInd, NTravelProto::NPriceChecker::TPriceFilterRecord priceFilter);

        void HandleCheckResult(const NTravelProto::TSearchOffersReq& request, const NTravelProto::TSearchOffersRsp& response);

        void InitPriceFilterTable();
        void InitMappers();

        NGrpc::TAsyncClient<NTravelProto::NOfferCacheGrpc::OfferCacheServiceV1> OfferCacheClient_;
        TYtTableCache<NTravelProto::NPriceChecker::TPriceFilterRecord> PriceFilterTable_;
        NPermalinkMappers::TPermalinkToClusterMapper PermalinkToClusterMapper_;
        NPermalinkMappers::TPermalinkToOriginalIdsMapper PermalinkToOriginalIdsMapper_;
        TYtPersistentConfig<EPartnerId, NTravelProto::NConfig::TPartner> YtConfigPartners_;
        TInstant Start_;
        std::atomic<int> Epoch_;
        NMonitor::TCounterHypercube<TSpecificCounters> SpecificCounters_;
        TCommonCounters CommonCounters_;
        double Rps_;
        TAtomicFlag IsStopped_;

        TMutex RunningChecksMutex_;
        THashMap<TString, RunningCheck> RunningChecks_;

        TMutex PriceFiltersMutex_;
        TAtomicSharedPtr<TVector<NTravelProto::NPriceChecker::TPriceFilterRecord>> PriceFilters_;
        TAtomicSharedPtr<TVector<NTravelProto::NPriceChecker::TPriceFilterRecord>> NewPriceFilters_;

        const TDuration MaxCheckWaitTime_ = TDuration::Minutes(5);
    };
}
