#pragma once

#include "offer_tracking_state.h"

#include <travel/hotels/lib/cpp/logging/common_logger.h>
#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/proto2/bus_messages.pb.h>
#include <travel/hotels/pricechecker/proto/pricechecker_logrecord.pb.h>

namespace NTravel::NPriceChecker {
    class TTrackingResultsConsumer {
    public:
        using TPriceCheckerLogRecord = NTravelProto::NPriceChecker::TPriceCheckerLogRecord;

        explicit TTrackingResultsConsumer(NTravelProto::NAppConfig::TConfigLogger config);
        void Start();
        void Stop();
        void HandleTrackingResult(const TOfferTrackingState& trackingState);
        void RegisterCounters(NMonitor::TCounterSource& source, const TString& name);
        void ReopenLog();

    private:
        struct TCounters: public NMonitor::TCounterSource {
            TCounters();

            NMonitor::TDerivCounter NUnknown;
            NMonitor::TDerivCounter NPriceDiffer;
            NMonitor::TDerivCounter NPriceNotFound;
            NMonitor::TDerivCounter NNoChanges;
            NMonitor::TDerivCounter NError;

            NMonitor::TDerivCounter NPriceIsSmaller;
            NMonitor::TDerivCounter NPriceIsBigger;
            NMonitor::TDerivCounter NPriceIsApproxSame;
            NMonitor::TDerivCounter NPriceIsApproxSmaller;
            NMonitor::TDerivCounter NPriceIsApproxBigger;

            NMonitor::TDerivHistogramCounter NPricePercentSmaller;
            NMonitor::TDerivHistogramCounter NPricePercentBigger;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;

            constexpr static const std::initializer_list<int> HistogramBuckets = {1, 5, 20, 50};
        };

        struct TResultVisitor {
            explicit TResultVisitor(TTrackingResultsConsumer::TPriceCheckerLogRecord* logRecord,
                                    TAtomicSharedPtr<TCounters> counters);

            void operator()(const TUnknownTrackingResult& result) const;

            void operator()(const TPriceDifferTrackingResult& result) const;

            void operator()(const TPriceNotFoundTrackingResult& result) const;

            void operator()(const TNoChangesTrackingResult& result) const;

            void operator()(const TErrorTrackingResult& result) const;

            TTrackingResultsConsumer::TPriceCheckerLogRecord* LogRecord;
            TAtomicSharedPtr<TCounters> Counters;
        };

        constexpr static const double PriceRelTolerance = 0.01;

        NMonitor::TCounterHypercube<TCounters> Counters_;
        TCommonLogger<TPriceCheckerLogRecord> PriceCheckerLogger_;

        TPriceCheckerLogRecord BuildLogRecord(const TOfferTrackingResult& trackingResult) const;

        TAtomicSharedPtr<TCounters> GetCountersForOperator(NTravelProto::EOperatorId operatorId);
    };

}
