#pragma once

#include "offer_tracking_state.h"
#include "offer_tracker_counters.h"

#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/proto2/bus_messages.pb.h>
#include <travel/hotels/pricechecker/proto/config.pb.h>

namespace NTravel::NPriceChecker {
    class TTrackingStrategy {
    public:
        TTrackingStrategy(const NTravelProto::NPriceChecker::TConfig_TTrackingStrategy& trackingStrategyConfig, TOfferTrackerCounters* counters);
        void RegisterCounters(NMonitor::TCounterSource& source, const TString& name);
        bool GetNextCheckInfoOrError(TOfferTrackingState* state, TInstant now, TInstant* nextCheckTime, size_t* nextCheckId) const;
        void HandleCheckResult(TOfferTrackingState* state,
                               TInstant timestamp,
                               size_t checkId,
                               const TVector<NTravelProto::TOffer>& offers);
        void HandleCheckError(TOfferTrackingState* state, TInstant timestamp, const TString& error);
        void HandleSearcherTimeout(TOfferTrackingState* state, TInstant timestamp);
        TDuration GetLifetime(TOfferTrackingState* state, TInstant now);
        bool TryGetNextCheckInfo(TOfferTrackingState* state, TInstant* nextCheckTime, size_t* nextCheckId) const;

    private:
        const TDuration MaxCheckDelay_ = TDuration::Minutes(1);
        const TDuration RetryDelay_ = TDuration::Minutes(1);

        TVector<size_t> CheckingTimes_;
        TOfferTrackerCounters* Counters_;

        bool AreOffersEquivalent(const NTravelProto::TOffer& firstOffer, const NTravelProto::TOffer& secondOffer);

        static void HandleError(TOfferTrackingState* state, TInstant timestamp, const TString& error);
        static int GetOfferPrice(const NTravelProto::TOffer& offer);
        static bool ArePricesEquivalent(double oldPrice, double newPrice);
    };

}
