#pragma once

#include "data.h"

#include <travel/hotels/pricechecker/proto/config.pb.h>
#include <travel/hotels/lib/cpp/mon/counter.h>

#include <library/cpp/containers/concurrent_hash/concurrent_hash.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/system/mutex.h>

namespace NTravel {
namespace NPriceChecker {

class TCache {
public:
    TCache(const NTravelProto::NPriceChecker::TConfig::TCache& config);
    ~TCache() = default;

    void RegisterCounters(NMonitor::TCounterSource& source);

    void AddOffers(TInstant expireTimestamp, const TSearcherResponse& searcherResponse);
    TOfferWithRequestRef GetOfferWithRequest(const TOfferId& offerId) const;
private:
    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TCounter NCachedOffers;
        NMonitor::TCounter NCachedRequests;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    const TDuration AdditionalCacheTime_;

    TCounters Counters_;

    static const int NUM_BUCKETS = 64;
    using TOffersMap = TConcurrentHashMap<TOfferId, TOfferWithRequestRef, NUM_BUCKETS, TRWMutex>;
    TOffersMap Offers_;
};

} // namespace NPriceChecker
} // namespace NTravel
