#include "data.h"

#include <util/stream/format.h>

namespace NTravel::NPriceChecker {

TString OfferIdToString(const TOfferId& offerId) {
    TStringStream raw;
    raw << Hex(offerId.dw[0], HF_FULL)
        << Hex(offerId.dw[1], HF_FULL)
        << Hex(offerId.dw[2], HF_FULL)
        << Hex(offerId.dw[3], HF_FULL);

    TStringStream stream;
    for (const auto& ch: ToLowerUTF8(raw.Str())) {
        if (ch == '-') {
            continue;
        }
        stream << ch;
        auto sz = stream.Size();
        if (sz == 8 || sz == 13 || sz == 18 || sz == 23) {
            stream << '-';
        }
    }
    return stream.Str();
}

}