#pragma once

#include <travel/hotels/lib/cpp/yt/queue_reader_with_confirmation.h>
#include <travel/hotels/proto2/hotels.pb.h>

#include <util/generic/maybe.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>

namespace NTravel {
namespace NPriceChecker {

using TRequestId = TString;
using TOfferId = TGUID;

struct TOfferWithRequest : public TThrRefBase {
    TAtomicSharedPtr<NTravelProto::TSearchOffersReq> RequestPb;
    NTravelProto::EOperatorId OperatorId;
    TOfferId OfferId;
    size_t OfferHash;
    int OfferPrice;
};

using TOfferWithRequestRef = TIntrusivePtr<TOfferWithRequest>;

enum class ESearcherResponseType {
    PLACEHOLDER,
    ERROR,
    OFFER
};

struct TSearcherResponse {
    TRequestId RequestId;
    TString RequestOfferCacheClientId;
    ESearcherResponseType Type;
    TString Error;
    TVector<TOfferWithRequestRef> OffersWithRequests;
};

TString OfferIdToString(const TOfferId& offerId);

} // namespace NPriceChecker
} // namespace NTravel
