#include "job_generator.h"

#include <travel/hotels/lib/cpp/scheduler/scheduler.h>

namespace NTravel {
namespace NPriceChecker {

void TJobGenerator::TCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NAwaitingJobs));
    ct->insert(MAKE_COUNTER_PAIR(NGeneratedJobs));
}

TJobGenerator::TJobGenerator(const NTravelProto::NPriceChecker::TConfig::TJobGenerator& config,
                             TJobProcessor& jobProcessor)
    : JobProcessor_(jobProcessor)
{
    for (const auto& samplingRulePb : config.GetSamplingRule()) {
        TSamplingRule samplingRule;
        samplingRule.Name = samplingRulePb.GetName();
        samplingRule.Probability = samplingRulePb.GetProbability();
        samplingRule.CheckDelay = TDuration::Seconds(samplingRulePb.GetCheckDelaySec());
        SamplingRules_.push_back(samplingRule);
    }
}

void TJobGenerator::RegisterCounters(NMonitor::TCounterSource& source) {
    source.RegisterSource(&Counters_, "JobGenerator");
}

const TVector<TJobGenerator::TSamplingRule>& TJobGenerator::GetSamplingRules() {
    return SamplingRules_;
}

void TJobGenerator::MaybeGenerateJob(TInstant timestamp, const TVector<TOfferWithRequestRef>& offersWithRequests) {
    if (offersWithRequests.empty()) {
        return;
    }
    for (const auto& samplingRule : SamplingRules_) {
        const auto deadline = timestamp + samplingRule.CheckDelay;
        if (deadline >= Now() && RandomNumber<double>() < samplingRule.Probability) {
            const auto& selectedOfferWithRequest = offersWithRequests[RandomNumber<size_t>(offersWithRequests.size())];
            Counters_.NGeneratedJobs.Inc();
            Counters_.NAwaitingJobs.Inc();
            NTravel::TScheduler::Instance().Enqueue(deadline, [this, selectedOfferWithRequest, samplingRule, timestamp]() {
                Counters_.NAwaitingJobs.Dec();
                JobProcessor_.AddInternalJob(selectedOfferWithRequest, samplingRule.Name, timestamp);
            });
        }
    }
}

} // namespace NPriceChecker
} // namespace NTravel
