#pragma once

#include "data.h"
#include "job_processor.h"

namespace NTravel {
namespace NPriceChecker {

class TJobGenerator {
public:
    struct TSamplingRule {
        TString Name;
        double Probability;
        TDuration CheckDelay;
    };

    TJobGenerator(const NTravelProto::NPriceChecker::TConfig::TJobGenerator& config,
                  TJobProcessor& jobProcessor);
    ~TJobGenerator() = default;

    void RegisterCounters(NMonitor::TCounterSource& source);

    const TVector<TSamplingRule>& GetSamplingRules();
    void MaybeGenerateJob(TInstant timestamp, const TVector<TOfferWithRequestRef>& offersWithRequests);
private:
    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TCounter NAwaitingJobs;
        NMonitor::TDerivCounter NGeneratedJobs;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    TJobProcessor& JobProcessor_;
    TVector<TSamplingRule> SamplingRules_;

    TCounters Counters_;
};

} // namespace NPriceChecker
} // namespace NTravel
