#pragma once

#include <travel/hotels/pricechecker/service/old/cache.h>
#include <travel/hotels/pricechecker/service/old/job_generator.h>
#include <travel/hotels/pricechecker/service/old/job_processor.h>
#include <travel/hotels/pricechecker/service/new/offer_tracker.h>
#include <travel/hotels/pricechecker/service/new/tracking_results_consumer.h>
#include <travel/hotels/pricechecker/proto/config.pb.h>

#include <travel/hotels/proto/data_config/operator.pb.h>

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/logging/common_logger.h>
#include <travel/hotels/lib/cpp/mon/page.h>
#include <travel/hotels/lib/cpp/yt/queue_reader.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>
#include <travel/hotels/lib/cpp/yt/lock.h>
#include <travel/hotels/lib/cpp/yt/queue_reader_with_confirmation.h>
#include <travel/hotels/lib/cpp/util/restart_detector.h>
#include <travel/hotels/pricechecker/service/new/price_filter_checker.h>

namespace NTravel {
namespace NPriceChecker {

class TService {
public:
    TService(const NTravelProto::NPriceChecker::TConfig& config);
    ~TService() = default;

    void Run();
    void Stop();

    EPartnerId GetPartnerIdByOperatorId(EOperatorId opId) const;
private:
    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TCounter IsWaiting;
        NMonitor::TCounter IsWorking;
        NMonitor::TCounter IsReady;

        NMonitor::TDerivCounter NLatePriceCheckRequests;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    const NTravelProto::NPriceChecker::TConfig Config_;
    const TDuration RequestMaxLateness_;

    NMonitor::TBasicPage CountersPage_;
    NMonitor::THttpService MonWebService_;
    NHttp::TServer Http_;

    TCounters Counters_;

    TYtLock DistributedLock_;

    TYtPersistentConfig<EOperatorId, NTravelProto::NConfig::TOperator> YtConfigOperators_;
    TYtQueueReader OfferBus_;
    TYtQueueReaderWithConfirmation PriceCheckReqBus_;
    TCommonLogger<TJobProcessor::TLogRecord> ReqAnsLogger_;
    TCache Cache_;
    TJobProcessor JobProcessor_;
    TJobGenerator JobGenerator_;
    TRestartDetector RestartDetector_;
    TOfferTracker OfferTracker_;
    TTrackingResultsConsumer TrackingResultsConsumer_;
    TPriceFilterChecker PriceFilterChecker_;

    void OnReopenLogs(const NHttp::TRequest&, const NHttp::TOnResponse& responseCb);
    void OnSetLogLevel(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);

    bool ProcessSearcherMessage(const TYtQueueMessage& busMessage, const ru::yandex::travel::hotels::TSearcherMessage& parsedMessage);
    bool ProcessPriceCheckRequest(const TYtQueueMessage& busMessage);

    TSearcherResponse ParseSearcherResponse(const NTravelProto::TSearchOffersReq& req,
                                            const NTravelProto::TSearchOffersRsp& rsp);
};

} // namespace NPriceChecker
} // namespace NTravel
