package ru.yandex.travel.hotels.promogranter

import org.slf4j.LoggerFactory
import org.springframework.boot.SpringApplication
import org.springframework.boot.autoconfigure.SpringBootApplication
import ru.yandex.travel.infrastructure.ConfigProcessorApplicationListener
import ru.yandex.travel.natives.Natives

@SpringBootApplication
open class PromoGranterApplication {
    companion object {
        private val log = LoggerFactory.getLogger(PromoGranterApplication::class.java)

        @JvmStatic
        fun main(args: Array<String>) {
            if (System.getenv("LOCK_MEMORY").toBoolean()) {
                log.info("Locking virtual memory pages to RAM")
                Natives.tryMlockall()
            }

            val app = SpringApplication(PromoGranterApplication::class.java)

            app.addListeners(ConfigProcessorApplicationListener())
            app.run(*args)
        }
    }
}
