package ru.yandex.travel.hotels.promogranter.grpc

import com.google.common.collect.ImmutableSet
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.context.annotation.Primary
import ru.yandex.travel.grpc.interceptors.LoggingServerInterceptorBlacklistMethodsSupplier
import ru.yandex.travel.hotels.proto.promogranter_service.PingServiceV1Grpc

@Configuration
open class GrpcCustomConfiguration {
    @Bean
    @Primary
    open fun loggingServerInterceptorBlacklistMethodsSupplier(): LoggingServerInterceptorBlacklistMethodsSupplier {
        return LoggingServerInterceptorBlacklistMethodsSupplier { ImmutableSet.of(PingServiceV1Grpc.getPingMethod().fullMethodName) }
    }
}
