package ru.yandex.travel.hotels.promogranter.grpc

import io.grpc.stub.StreamObserver
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.actuate.health.HealthEndpoint
import org.springframework.boot.actuate.health.Status

import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.proto.TPingRpcReq
import ru.yandex.travel.hotels.proto.TPingRpcRsp
import ru.yandex.travel.hotels.proto.promogranter_service.PingServiceV1Grpc

@GrpcService(trace = false)
class PingGrpcService(
    @Autowired private val healthEndpoint: HealthEndpoint
) : PingServiceV1Grpc.PingServiceV1ImplBase() {

    private val log = LoggerFactory.getLogger(this.javaClass)

    override fun ping(request: TPingRpcReq, responseObserver: StreamObserver<TPingRpcRsp>) {
        responseObserver.onNext(TPingRpcRsp.newBuilder()
            .setIsReady(healthEndpoint.health().status === Status.UP)
            .build())
        responseObserver.onCompleted()
    }
}
