package ru.yandex.travel.hotels.promogranter.grpc

import com.google.common.base.Preconditions
import com.google.common.base.Strings
import io.grpc.stub.StreamObserver
import org.springframework.boot.context.properties.EnableConfigurationProperties
import ru.yandex.travel.grpc.GrpcService
import ru.yandex.travel.hotels.promogranter.PromoGranterProperties
import ru.yandex.travel.hotels.promogranter.services.plus_topup.PlusTopupInitializerService
import ru.yandex.travel.hotels.proto.promogranter_service.PromoGranterServiceV1Grpc
import ru.yandex.travel.hotels.proto.promogranter_service.TCreateAdditionalBindingReq
import ru.yandex.travel.hotels.proto.promogranter_service.TCreateAdditionalBindingRsp

@GrpcService(authenticateService = true)
@EnableConfigurationProperties(PromoGranterProperties::class)
class PromoGranterGrpcService(
    private val plusTopupInitializerService: PlusTopupInitializerService,
) : PromoGranterServiceV1Grpc.PromoGranterServiceV1ImplBase() {

    override fun createAdditionalBinding(request: TCreateAdditionalBindingReq, responseObserver: StreamObserver<TCreateAdditionalBindingRsp>) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(request.tourId), "tourId is required");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(request.userIp), "UserIp is required");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(request.passportId), "PassportId is required");

        val result = plusTopupInitializerService.tryCreateAdditionalBinding(request.tourId, request.checkInDate, request.checkOutDate, request.userIp, request.passportId)

        val rspBuilder = TCreateAdditionalBindingRsp.newBuilder()
        rspBuilder.setCreationStatus(result.first)
        if (result.second != null) {
            rspBuilder.setExpectedTopupDate(result.second.toString())
        }
        responseObserver.onNext(rspBuilder.build())
        responseObserver.onCompleted()
    }
}
