package ru.yandex.travel.hotels.promogranter.repositories

import org.jooq.DSLContext
import org.jooq.TransactionalRunnable
import org.jooq.impl.DSL
import ru.yandex.travel.hotels.promogranter.PromoGranterProperties

fun DSLContext.transactionSerializable(promoGranterProperties: PromoGranterProperties, transactionalRunnable: TransactionalRunnable) {
    if (promoGranterProperties.usePostgresSpecificCommands) {
        transaction { configuration ->
            val ctx = DSL.using(configuration)

            ctx.execute("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE")
            if (ctx.fetchOne("SHOW TRANSACTION ISOLATION LEVEL").get(0) as String != "serializable") {
                throw Exception("Transaction mode is not serializable")
            }

            transactionalRunnable.run(configuration)
        }
    } else {
        transaction(transactionalRunnable)
    }
}
