package ru.yandex.travel.hotels.promogranter.services.orders_client;

import java.util.List;

import io.opentracing.Tracer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.orders.client.ChannelState;
import ru.yandex.travel.orders.client.GrpcChannelSupplierPropertiesBase;
import ru.yandex.travel.orders.client.GrpcServiceConfigurationBase;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;
import ru.yandex.travel.orders.proto.EServerState;
import ru.yandex.travel.orders.proto.HADiscoveryInterfaceV1Grpc;
import ru.yandex.travel.orders.proto.TPingRpcReq;
import ru.yandex.travel.tvm.TvmWrapper;

@Configuration
@EnableConfigurationProperties(OrchestratorConfigurationProperties.class)
@Slf4j
public class OrchestratorConfiguration extends GrpcServiceConfigurationBase {
    public OrchestratorConfiguration(GrpcChannelSupplierPropertiesBase properties, Tracer tracer) {
        super(properties, tracer);
    }

    @Bean("OrchestratorGrpcChannelFactory")
    public HAGrpcChannelFactory haGrpcChannelFactory(@Autowired(required = false) TvmWrapper tvm) {
        return getGrpcChannelFactory(tvm, channel -> FutureUtils.buildCompletableFuture(HADiscoveryInterfaceV1Grpc
                        .newFutureStub(channel)
                        .ping(TPingRpcReq.newBuilder().build())
                ).thenApply((rsp) -> rsp.getState() == EServerState.SS_MASTER ? ChannelState.READY_MASTER :
                        ChannelState.READY),
                null, List.of(HADiscoveryInterfaceV1Grpc.getPingMethod()));
    }
}
